<?php
# WebChangePwd 1.0
# for MODX Evolution, EVO CMS v1.x and v2.x
# Created By Raymond Irving April, 2005
#
# Translated into German info@myw3d.de 2016-12-07
#::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::

defined('IN_PARSER_MODE') or die();

# load tpl
if(is_numeric($tpl)) $tpl = ($doc=$modx->getDocuments($tpl)) ? $doc['content']:"Dokument '$tpl' nicht gefunden.";
else if($tpl) $tpl = ($chunk=$modx->getChunk($tpl)) ? $chunk:"Chunk '$tpl' nicht gefunden.";
if(!$tpl) $tpl = getWebChangePwdtpl();

// extract declarations
$declare = webLoginExtractDeclarations($tpl);
$tpls = explode((isset($declare["separator"]) ? $declare["separator"]:"<!--tpl_separator-->"),$tpl);

if(!$isPostBack && isset($_SESSION['webValidated'])){
    // display password screen
    $tpl = $tpls[0];
    $tpl = str_replace("[+action+]",$modx->makeUrl($modx->documentIdentifier),$tpl);
    $tpl.="<script type='text/javascript'>
        if (document.changepwdfrm) document.changepwdfrm.oldpassword.focus();
        </script>";
    $output .= $tpl;
} 
else if ($isPostBack && isset($_SESSION['webValidated'])){
    $oldpassword = $_POST['oldpassword'];
    $genpassword = $_POST['newpassword'];
    $passwordgenmethod = $_POST['passwordgenmethod'];
    $passwordnotifymethod = $_POST['passwordnotifymethod'];
    $specifiedpassword = $_POST['specifiedpassword'];
    
    $uid = $modx->getLoginUserID();
    $type = $modx->getLoginUserType();

    // load template
    $tpl = $tpls[0];
    $tpl = str_replace("[+action+]",$modx->makeUrl($modx->documentIdentifier),$tpl);
    $tpl.="<script type='text/javascript'>if (document.changepwdfrm) document.changepwdfrm.oldpassword.focus();</script>";

    // get user record
    if($type=='manager') $ds = $modx->getUserInfo($uid);
    else $ds = $modx->getWebUserInfo($uid);

    // verify password
    if($ds['password']==md5($oldpassword)) {

        // verify password
        if ($passwordgenmethod=="spec" && $_POST['specifiedpassword']!=$_POST['confirmpassword']) {
            $output = webLoginAlert("Das eingegebene Kennwort stimmt nicht!",1).$tpl;
            return;
        }

        // generate a new password for this user
        if($specifiedpassword!="" && $passwordgenmethod=="spec") {
            if(strlen($specifiedpassword) < 6 ) {
                $output = webLoginAlert("Das Kennwort ist zu kurz!").$tpl;
                return;
            } else {
                $newpassword = $specifiedpassword;
            }            
        } elseif($specifiedpassword=="" && $passwordgenmethod=="spec") {
            $output = webLoginAlert("Bitte gib ein Kennwort ein!").$tpl;
            return;        
        } elseif($passwordgenmethod=='g') {
            $newpassword = webLoginGeneratePassword(8);        
        } else {
            $output = webLoginAlert("Bitte whle, wie das Kennwort erstellt werden soll!").$tpl;
            return;
        }

        // handle notification
        if($passwordnotifymethod=='e') {
            $rt = webLoginSendNewPassword($ds["email"],$ds["username"],$newpassword,$ds["fullname"]);
            if($rt!==true) { // an error occured
                $output = $rt.$tpl;
                return;
            }
            else {
                $newpassmsg = "Dein neues Kennwort wurde an deine E-Mail-Adresse versandt. Es kann ein paar Minuten dauern, bis die Mail ankommt.";
            }
        }
        else {
            $newpassmsg = "Dein neues Kennwort lautet: <b>" . htmlspecialchars($newpassword, ENT_QUOTES) . "</b>.";
        }
        
        // save new password to database
        $rt = $modx->changeWebUserPassword($oldpassword,md5($newpassword));
        if($rt!==true) {
            $output = webLoginAlert("WEBLOGIN Error 0x000000. WebChangePdw.inc.php: An error occured while saving new password: $rt. Das Kennwort konnte nicht gespeichert werden!");
            return;
        }        
        
        // display change notification
        $tpl = $tpls[1];
        $tpl = str_replace("[+newpassmsg+]",$newpassmsg,$tpl);    
        $output .= $tpl;
    }
    else {    
        $output = webLoginAlert("Das Kennwort stimmt nicht. Bitte versuche es noch einmal.").$tpl;
        return;
    }
}

// Returns Default WebChangePwd tpl
function getWebChangePwdtpl(){
    ob_start();
    ?>
    <!-- #declare:separator <hr> --> 
    <!-- login form section-->
    <form method="post" name="changepwdfrm" action="[+action+]" style="margin: 0px; padding: 0px;">
      <table border="0" cellpadding="1" width="300">
        <tr>
          <td><fieldset style="width:300px">
          <legend><b>Aktuelles Kennwort</b></legend>
          <table border="0" cellpadding="0" style="margin-left:20px;">
            <tr>
              <td style="padding:0px 0px 0px 0px;">
              <label for="oldpassword" style="width:120px">Aktuelles Kennwort:</label>
              </td>
              <td style="padding:0px 0px 0px 20px;">
              <input type="password" name="oldpassword" size="20" /><br />
              </td>
            </tr>
          </table>
          </fieldset><br /> <fieldset style="width:300px">
          <legend><b>Kennwort &auml;ndern</b></legend>
          <input type="radio" name="passwordgenmethod" value="g" checked />Kennwort automatisch erzeugen<br />
          <input type="radio" name="passwordgenmethod" value="spec" />Ich m&ouml;chte selbst ein Kennwort eingeben:<br />
          <div style="padding-left:20px">
            <table border="0" cellpadding="0">
              <tr>
                <td style="padding:0px 0px 0px 0px;">
                <label for="specifiedpassword" style="width:120px">Neues Kennwort:</label>
                </td>
                <td style="padding:0px 0px 0px 0px;">
                <input type="password" name="specifiedpassword" onchange="documentdirty=true;" onkeypress="document.changepwdfrm.passwordgenmethod[1].checked=true;" size="20" /><br />
                </td>
              </tr>
              <tr>
                <td style="padding:0px 0px 0px 0px;">
                <label for="confirmpassword" style="width:120px">Neues Kennwort best&auml;tigen:</label>
                </td>
                <td style="padding:0px 0px 0px 0px;">
                <input type="password" name="confirmpassword" onchange="documentdirty=true;" onkeypress="document.changepwdfrm.passwordgenmethod[1].checked=true;" size="20" /><br />
                </td>
              </tr>
            </table>
            <small><span class="warning" style="font-weight:normal">Das Kennwort muss mindestens 6 Zeichen lang sein.</span></small>
          </div>
          </fieldset><br />
          <fieldset style="width:300px">
          <legend><b>Kennwort best&auml;tigen</b></legend>
          <input type="radio" name="passwordnotifymethod" value="e" />Kennwort per E-Mail senden.<br />
          <input type="radio" name="passwordnotifymethod" value="s" checked />Kennwort am Bilschirm anzeigen.
          </fieldset></td>
        </tr>
        <tr>
          <td align="right"><input type="submit" value="Kennwort &auml;ndern" name="cmdwebchngpwd" />
          <input type="reset" value="Zur&uuml;cksetzen" name="cmdreset" />
          </td>
        </tr>
      </table>
    </form>
    <hr>
    <!-- notification section -->
    Das Kennwort wurde erfolgreich ge&auml;ndert.<br /><br />
    [+newpassmsg+]
    <?php 
    $t = ob_get_contents();
    ob_end_clean();
    return $t;
}
?>